import LicenseSpring

import SwiftUI
import UniformTypeIdentifiers

struct InitialViewContainer<Content: View>: View {
    @State private var productDetails: ProductDetails?
    
    let manager: LicenseManager!
    @Binding var showConfiguration: Bool
    let showProductDetails: Bool
    @ViewBuilder var content: () -> Content
    
    @EnvironmentObject private var viewUpdater: ViewUpdaterHack
    
    var body: some View {
        VStack {
            Image("MainLogo")
                .resizable()
                .aspectRatio(contentMode: .fit)
                .frame(height: 100)
            HStack {
                if showProductDetails {
                    MinWidthButton("Product Details") {
                        performAction(name: "Product Details", successAlert: false) {
                            productDetails = try manager.requestProductDetails()
                        }
                    }
                }
                Spacer()
                Button("Configure...") { showConfiguration = true }

            }
            content()
        }
        .padding()
        .sheet(isPresented: .constant(productDetails != nil), onDismiss: { productDetails = nil }) {
            ProductDetailsView(productDetails: $productDetails)
        }
    }
}
